<?php
/* --------------------------------------------------------------
 SearchOperator.php  2019-10-25
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2019 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace Gambio\Core\Configuration\Types;

use Gambio\Core\Configuration\Models\Read\Collections\Options;
use Gambio\Core\Configuration\Repositories\Components\OptionsResolver;

/**
 * Class SearchOperator
 * @package Gambio\Core\Configuration\Types
 */
class SearchOperator implements ConfigurationType
{
    /**
     * Resolves possible options for the current type.
     * This is used to provide selectable list in the ui and can be null.
     *
     * @param OptionsResolver $resolver
     * @param string|null     $value
     *
     * @return Options|null
     */
    public function toOptions(OptionsResolver $resolver, string $value = null): ?Options
    {
        $data = [
            [
                'text'  => $resolver->getText('GM_CFG_AND', 'gm_general'),
                'value' => 'and',
            ],
            [
                'text'  => $resolver->getText('GM_CFG_OR', 'gm_general'),
                'value' => 'or',
            ]
        ];
        
        return Options::fromArray($data);
    }
    
    
    /**
     * Defines the UI's input type for current configuration type.
     *
     * @return string
     */
    public function inputType(): string
    {
        return 'dropdown';
    }
}